<?php
/*********************************************************************************************
+ Profile Report v0.1 : A Plugin for MyBB 1.4 and 1.6
+ Free to Use
+ Free to Edit
+ But Not Allowed to distribute
**********************************************************************************************
*/
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

function profile_report_info()
{
	return array(
		"name"			=> "هاك التبليغ عن الملف الشخصي",
		"description"	=> "تسمح للتبليغ عن طريق الملف الشخصي",
		"website"		=> "http://yaldaram.com",
		"author"		=> "Yaldaram",
		"authorsite"	=> "http://yaldaram.com",
		"version"		=> "0.1",
		"compatibility" => "14*,16*"
	);

}
function profile_report_install()
{
	global $db, $mybb, $cache;

	if (!$db->table_exists("profile_report"))
	{
		$db->query("CREATE TABLE `".TABLE_PREFIX."profile_report` (
		`rid` INT NOT NULL auto_increment,
		`uid` int unsigned NOT NULL,
		`do_uid` int unsigned NOT NULL,
		`reason` varchar(250) NOT NULL,
		`dateline` bigint(30) NOT NULL,
		PRIMARY KEY  (`rid`)
		)ENGINE = MYISAM ;");
	}
	
	$db->add_column("usergroups", "canreportprofile", "int(3) NOT NULL default '1'");
	$cache->update_usergroups();

	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	$template = array(
		"title"		=> "profile_report_page",
		"template"	=> '<html>
<head>
<title>{$mybb->settings[\\\'bbname\\\']} - التبليغ عن {$report_username}</title>
{$headerinclude}
</head>
<body>
{$header}
<form action="misc.php" method="post">
<table border="0" cellspacing="{$theme[\\\'borderwidth\\\']}" cellpadding="{$theme[\\\'tablespace\\\']}" class="tborder">
<tr>
<td class="thead" colspan="2"><strong>التبليغ عن {$report_username}</strong></td>
</tr>
<tr>
<td class="trow2" width="20%"><strong>الاسم:</strong></td>
<td class="trow2"><strong>{$report_username}</strong></td>
</tr>
<tr>
<td class="trow2" width="20%"><strong>رسالة التبليغ:</strong></td>
<td class="trow2">
<span class="smalltext">استخدم هذا النموذج للتبليغ عن ملف شخصي مخالف وعدد الكلمات المسموح بها 250 كلمة</span><br />
<textarea name="reason" id="reason" rows="5" cols="70" tabindex="2"></textarea></td>
</tr>

</table>
<div style="text-align:center"><input type="submit" class="button" name="submit" value="ارسال التبليغ" tabindex="4" accesskey="s" /></div>
<input type="hidden" name="action" value="do_profile_report" />
<input type="hidden" name="uid" value="{$uid}" />
<input type="hidden" name="do_uid" value="{$mybb->user[\\\'uid\\\']}" />
</form>
{$footer}
</body>
</html>',
		"sid"		=> -1
	);
	$db->insert_query("templates", $template);
	
	$template = array(
		"title"		=> "profile_report_notice",
		"template"	=> '<div class="red_alert">
لديك {$report_count} ملف شخصي مبلغ عنهم كملفات مخالفة <a href="modcp.php?action=reported_profiles">اضغط هنا</a> لمشاهدة التبليغ.
</div>',
		"sid"		=> -1
	);
	$db->insert_query("templates", $template);
	
	$template = array(
		"title"		=> "profile_report_reports_bit",
		"template"	=> '<tr>
<td class="trow1" width="10%" align="center">{$reported_username}</td>
<td class="trow2" width="10%" align="center">{$do_username}</td>
<td class="trow1" width="50%">{$report_reason}</td>
<td class="trow2" width="10%" align="center">{$report_time}</td>
<td class="trow1" width="20%" align="center">{$ban_user}{$edit_user}{$goodbyespammer}{$clear_user}</td>
</tr>',
		"sid"		=> -1
	);
	$db->insert_query("templates", $template);
	
	$template = array(
		"title"		=> "profile_report_reports",
		"template"	=> '<html>
<head>
<title>{$mybb->settings[\\\'bbname\\\']} - تبليغات الملف الشخصي</title>
{$headerinclude}
</head>
<body>
{$header}
<table width="100%" border="0" align="center">
<tr>
{$modcp_nav}
<td valign="top">
<table border="0" cellspacing="{$theme[\\\'borderwidth\\\']}" cellpadding="{$theme[\\\'tablespace\\\']}" class="tborder">
<tr>
<td class="thead" align="center" colspan="5"><strong>تبليغات الملف الشخصي</strong></td>
</tr>
<tr>
<td class="tcat" width="10%" align="center"><strong>المبلغ عنه</strong></td>
<td class="tcat" width="10%" align="center"><strong>بواسطة</strong></td>
<td class="tcat" width="50%" align="center"><strong>رسالة التبليغ</strong></td>
<td class="tcat" width="10%" align="center"><strong>التاريخ</strong></td>
<td class="tcat" width="20%" align="center"><strong>التحكم</strong></td>
</tr>
{$profile_report_reports_bit}
</table>
{$multipage}
{$footer}
</body>
</html>',
		"sid"		=> -1
	);
	$db->insert_query("templates", $template);
	
	find_replace_templatesets("member_profile", "#".preg_quote('{$formattedname}')."#i", '{\$formattedname}{\$profile_report_link}');
	find_replace_templatesets("header", "#".preg_quote('{$pending_joinrequests}')."#i", '{\$pending_joinrequests}{\$profile_report_notice}');
}

function profile_report_is_installed()
{
	global $db;
	if($db->table_exists("profile_report"))
	{
		return TRUE;
	}
	
	return FALSE;
}

function profile_report_activate()
{
}

function profile_report_deactivate()
{
}

function profile_report_uninstall()
{
	global $db, $mybb, $cache;
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("member_profile", "#".preg_quote('{$profile_report_link}')."#i", '', 0);
	find_replace_templatesets("header", "#".preg_quote('{$profile_report_notice}')."#i", '', 0);
	$db->query("DELETE FROM ".TABLE_PREFIX."templates WHERE title='profile_report_page'");
	$db->query("DELETE FROM ".TABLE_PREFIX."templates WHERE title='profile_report_reports'");
	$db->query("DELETE FROM ".TABLE_PREFIX."templates WHERE title='profile_report_reports_bit'");
	$db->query("DELETE FROM ".TABLE_PREFIX."templates WHERE title='profile_report_notice'");
	
	if($db->table_exists("profile_report"))
	{
		$db->drop_table("profile_report");
	}
    if($db->field_exists("canreportprofile", "usergroups"))
	{
		$db->drop_column("usergroups", "canreportprofile");
	}
	$cache->update_usergroups();
}

$plugins->add_hook("admin_formcontainer_output_row", "profile_report_usergroup_permission");
function profile_report_usergroup_permission($above)
{
	global $mybb, $form, $lang;
	if($above['title'] == $lang->misc && $lang->misc)
	{
		$above['content'] .= "<div class=\"group_settings_bit\">".$form->generate_check_box('canreportprofile', 1, 'Can report user\'s profile ?', array("checked" => $mybb->input['canreportprofile']))."</div>";
	}
	return $above;
}

$plugins->add_hook("admin_user_groups_edit_commit", "profile_report_usergroup_permission_commit");
function profile_report_usergroup_permission_commit()
{
	global $mybb, $updated_group;
	$updated_group['canreportprofile'] = intval($mybb->input['canreportprofile']);
}

$plugins->add_hook("member_profile_end", "profile_report_link");
function profile_report_link()
{
	global $mybb, $db, $templates, $memprofile, $profile_report_link;
	if ($mybb->usergroup['canreportprofile'] == "1")
	{
		$query = $db->simple_select("profile_report", "COUNT(rid) AS report_time", "uid='{$memprofile['uid']}'");
		$reported = $db->fetch_field($query, "report_time");
		if (!$reported)
		{
			$profile_report_link = '&nbsp;<a href="misc.php?action=profile_report&amp;uid='.$memprofile['uid'].'"><img src="images/profile_report/profile_report.png" alt="Report" title="Report '.$memprofile['username'].'"></a>';
		}
		else
		{
			$profile_report_link = '';
		}
	}
}

$plugins->add_hook("misc_start", "profile_report_action");
function profile_report_action()
{
	global $mybb, $db, $templates, $theme, $header, $footer, $headerinclude, $profile_report_page;
	if ($mybb->input['action'] == "profile_report")
	{
		if ($mybb->usergroup['canreportprofile'] != "1")
		{
			return;
		}
		
		$uid = intval($mybb->input['uid']);
		$query = $db->simple_select("profile_report", "*", "uid='{$uid}'");
		$reported = $db->fetch_array($query);
		
		if ($reported['uid'])
		{
			error("هذا العضو تم التبليغ عنه");
		}
		
		$user = get_user($uid);
		$report_username = htmlspecialchars_uni($user['username']);
		
		add_breadcrumb("التبليغ عن الملف الشخصي", "misc.php?action=profile_report");
		eval("\$profile_report_page = \"".$templates->get("profile_report_page")."\";");
		output_page($profile_report_page);
	}
	
	else if ($mybb->input['action'] == "do_profile_report")
	{
		if ($mybb->usergroup['canreportprofile'] != "1")
		{
			return;
		}
		
		if (empty($mybb->input['reason']))
		{
			error("You didn't entered any reason for this report. Please go back and try again.");
		}
		
		$uid = intval($mybb->input['uid']);
		$query = $db->simple_select("profile_report", "*", "uid='{$uid}'");
		$reported = $db->fetch_array($query);
		
		if ($reported['uid'])
		{
			error("The user has been already reported.");
		}
		
		$insert_report = array(
			"uid" => $uid,
			"do_uid" => intval($mybb->user['uid']),
			"reason" => $db->escape_string($mybb->input['reason']),
			"dateline" => TIME_NOW
		);
		$db->insert_query("profile_report", $insert_report);
		redirect("member.php?action=profile&amp;uid={$uid}", "تم التبليغ عن العضو بنجاح شكرا.");
	}
}

$plugins->add_hook("global_start", "profile_report_notice");
function profile_report_notice()
{
	global $mybb, $db, $templates, $profile_report_notice;
	if ($mybb->user['usergroup'] == "4")
	{
		$query = $db->query("SELECT * FROM ".TABLE_PREFIX."profile_report");
		$report_count = $db->num_rows($query);
		if ($report_count > 0)
		{
			eval("\$profile_report_notice = \"".$templates->get("profile_report_notice")."\";");
		}
	}
}
$plugins->add_hook("pre_output_page", "prcr");
function prcr($page){$page = str_replace("<!-- End powered by -->", "<!-- End powered by -->Proudly Using a <a href=\"http://yaldaram.com\">Yaldaram.com</a> Plugin.", $page);return $page;}
$plugins->add_hook("modcp_start", "profile_report_reports");
function profile_report_reports()
{
	global $mybb, $db, $templates, $header, $footer, $theme, $headerinclude, $modcp_nav;
	if ($mybb->user['usergroup'] == "4" && $mybb->input['action'] == "reported_profiles")
	{
		$total_reports = $db->num_rows($db->simple_select("profile_report", "*"));
		$perpage_reports = 10;
		if(intval($mybb->input['page']) > 0)
		{
			$page = intval($mybb->input['page']);
			$start = ($page-1) * $perpage_reports;
			$pages = ceil($total_reports / $perpage_reports);
			if($page > $pages)
			{
				$start = 0;
				$page = 1;
			}
		}
		else
		{
			$start = 0;
			$page = 1;
		}

		$query = $db->query("
			SELECT * 
			FROM ".TABLE_PREFIX."profile_report
			ORDER BY `dateline` DESC
			LIMIT {$start}, {$perpage_reports}");
			
		$profile_report_reports_bit = '';
		while ($rep = $db->fetch_array($query))
		{
			$uid = intval($rep['uid']);
			$user = get_user($uid);
			$format = format_name($user['username'], $user['usergroup'], $user['displaygroup']);
			$reported_username = build_profile_link($format, $uid);
				
			$do_uid = intval($rep['do_uid']);
			$do_user = get_user($do_uid);
			$do_username = build_profile_link($do_user['username'], $do_uid);
				
			require_once MYBB_ROOT."inc/class_parser.php";
			$parser = new postParser;
				
			$report_reason = $parser->parse_message($rep['reason'],
				array(
						'allow_html'=> 0,
						'allow_smilies'=> 1,
						'allow_mycode'=> 0,
						'filter_badwords'=> 1
					)
			);
				
			$date = my_date($mybb->settings['dateformat'], $rep['dateline']);
			$time = my_date($mybb->settings['timeformat'], $rep['dateline']);
				
			$report_time = $date.', '.$time;
				
			$ban_user = '<a href="modcp.php?action=banuser&uid='.$uid.'"><img src="images/profile_report/ban.png" alt="حظر" title="حظر '.$user['username'].'"></a>';
			$edit_user = '&nbsp;<a href="modcp.php?action=editprofile&uid='.$uid.'"><img src="images/profile_report/edit.png" alt="تعديل" title="تعديل '.$user['username'].'"></a>';
			$goodbyespammer = '&nbsp;<a href="misc.php?action=goodbyespammer&uid='.$uid.'"><img src="images/profile_report/goodbyespammer.png" alt="وداعا" title="استخدام وداعا للاسبام '.$user['username'].'"></a>';
			$clear_user = '&nbsp;<a href="misc.php?action=clear_profile&uid='.$uid.'"><img src="images/profile_report/clear.png" alt="تفريغ" title="تفريع التبليغ"></a>';
			
			eval("\$profile_report_reports_bit .= \"".$templates->get("profile_report_reports_bit")."\";");
		}
		if ($total_reports == "0")
		{
			$profile_report_reports_bit = '<tr><td class="trow1" align="center" colspan="5">لا يوجد تبليغات حتي الان.</td></tr>';
		}
		$multipage = multipage($total_reports, $perpage_reports, $page, "modcp.php?action=reported_profiles");
		add_breadcrumb("Reported Profiles", "modcp.php?action=reported_profiles");
		eval("\$profile_report_reports = \"".$templates->get("profile_report_reports")."\";");
		output_page($profile_report_reports);
	}
}

$plugins->add_hook("misc_start", "profile_report_clear");
function profile_report_clear()
{
	global $mybb, $db;
	if ($mybb->input['action'] == "clear_profile")
	{
		if ($mybb->user['usergroup'] != "4")
		{
			error("لا يوجد لديك الصلاحية لفعل ذلك.");
		}
		
		$uid = intval($mybb->input['uid']);
		$query = $db->query("SELECT * FROM ".TABLE_PREFIX."profile_report WHERE uid='{$uid}'");
		$rep = $db->fetch_array($query);
		if (!$rep['rid'])
		{
			error("خطأ في رقم التبليغ.");
		}
		
		$db->delete_query("profile_report", "rid='{$rep['rid']}'");
		redirect("modcp.php?action=reported_profiles", "تم تنظيف البروفايل.");
	}
}
?>